---
generated_at: 2026-01-22 19:48:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-現在のユーザー情報（Who Am I）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/security/WhoAmI/index.jelly`
- E-02: `core/src/main/java/hudson/security/WhoAmI.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Who Am I画面で認証情報を表示 | E-01, E-03 | ○ |
| C-02 | URLは/whoAmI | E-02 (100行目) | ○ |
| C-03 | タイトルは"Who Am I?" | E-01 (35行目) | ○ |
| C-04 | ユーザー名（Name）を表示 | E-01 (39行目) | ○ |
| C-05 | 認証状態（IsAuthenticated?）を表示 | E-01 (43行目) | ○ |
| C-06 | 権限一覧（Authorities）を表示 | E-01 (46-61行目) | ○ |
| C-07 | リクエストヘッダーを表示 | E-01 (66-94行目) | ○ |
| C-08 | 危険なヘッダーは内容を隠す | E-01 (70-77行目), E-02 (31-35行目) | ○ |
| C-09 | UnprotectedRootActionを実装 | E-02 (30行目) | ○ |
| C-10 | REST APIを提供（@ExportedBean） | E-02 (29行目) | ○ |
| C-11 | Jenkins.READ権限でサイドパネル表示 | E-01 (30-32行目) | ○ |
| C-12 | app.authenticationで認証情報取得 | E-01 (34行目) | ○ |
| C-13 | dangerousHeadersにcookieが含まれる | E-02 (32行目) | ○ |
| C-14 | dangerousHeadersにauthorizationが含まれる | E-02 (34行目) | ○ |
| C-15 | isHeaderDangerousで安全性判定 | E-02 (83-86行目) | ○ |
| C-16 | null権限の場合"null"表示 | E-01 (52-54行目) | ○ |
| C-17 | 関連機能はユーザー管理(30)、権限管理(31) | E-04 | ○ |
| C-18 | getApi()でApiオブジェクトを返す | E-02 (37-39行目) | ○ |
| C-19 | getName()が@Exportedでエクスポート | E-02 (41-43行目) | ○ |
| C-20 | getAuthorities()が@Exportedでエクスポート | E-02 (70-79行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな情報表示画面で、全ての要素がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 危険なヘッダーのリストが適切か
- [ ] REST APIの出力が適切か
- [ ] サイドパネルの権限チェックが正しいか
